/*
 * Decompiled with CFR 0.152.
 */
package rpgboss.editor.util;

import com.google.common.io.Files;
import java.io.File;
import org.apache.commons.io.FileUtils;
import rpgboss.editor.Internationalized$;
import rpgboss.editor.util.Zip$;
import rpgboss.lib.Utils$;
import rpgboss.model.Project;
import rpgboss.save.SaveFile$;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.RichInt$;

public final class Export$ {
    public static final Export$ MODULE$;

    static {
        new Export$();
    }

    public void cleanGamedata(File dir) {
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), 50).foreach(new Serializable(dir){
            public static final long serialVersionUID = 0L;
            private final File dir$1;

            public final boolean apply(int i) {
                return this.apply$mcZI$sp(i);
            }

            public boolean apply$mcZI$sp(int i) {
                return SaveFile$.MODULE$.file(this.dir$1, i).delete();
            }
            {
                this.dir$1 = dir$1;
            }
        });
        FileUtils.deleteDirectory(new File(dir, Internationalized$.MODULE$.getMessage("Export")));
    }

    public void export(Project project, File executableJarFile) {
        File exportDir = new File(project.dir(), "export");
        exportDir.mkdir();
        if (exportDir.isDirectory()) {
            File gamedataDir = Files.createTempDir();
            FileUtils.copyDirectory(project.dir(), gamedataDir);
            this.cleanGamedata(gamedataDir);
            String libraryJarName = "rpgboss-library.jar";
            this.generatePackage$1("linux-mac", "exportresources/linux/launch.sh", "rpgboss", true, project, executableJarFile, exportDir, gamedataDir, libraryJarName);
            this.generatePackage$1("windows", "exportresources/win/rpgboss-player.exe", "rpgboss.exe", false, project, executableJarFile, exportDir, gamedataDir, libraryJarName);
            return;
        }
        throw new RuntimeException("Cannot write to export directory");
    }

    private final void generatePackage$1(String platformName, String launchSource, String launchTargetFilename, boolean needUnixPerms, Project project$1, File executableJarFile$1, File exportDir$1, File gamedataDir$1, String libraryJarName$1) {
        File tempDir = Files.createTempDir();
        String packageName = new StringOps(Predef$.MODULE$.augmentString("%s-%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{project$1.dir().getName(), platformName}));
        File dir = new File(tempDir, packageName);
        dir.mkdir();
        File launchFile = new File(dir, launchTargetFilename);
        FileUtils.copyFile(executableJarFile$1, new File(dir, libraryJarName$1));
        FileUtils.copyDirectory(gamedataDir$1, new File(dir, "gamedata"));
        Utils$.MODULE$.copyResource(launchSource, launchFile);
        launchFile.setExecutable(true, false);
        String zipName = new StringBuilder().append((Object)packageName).append((Object)".zip").toString();
        Zip$.MODULE$.zipFolder(dir, new File(exportDir$1, zipName), needUnixPerms);
    }

    private Export$() {
        MODULE$ = this;
    }
}

